/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.domain;

import com.ibm.hwmca.fw.domain.Domain;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DomainManager {
    private static final String TRACE_MASKT = "XFRMDM T";
    private static final String TRACE_MASKF = "XFRMDM F";
    private static final String TRACE_MASKD = "XFRMDM D";
    private static DomainManager manager = null;
    private Map domainMap = new HashMap();

    private DomainManager() {
        this.init();
    }

    private void init() {
        Trace.trace(TRACE_MASKD, "--> init()");
        Trace.trace(TRACE_MASKD, "<-- init()");
    }

    public static DomainManager getDomainManager() {
        if (manager == null) {
            manager = new DomainManager();
        }
        return manager;
    }

    public synchronized void put(Domain dom) {
        this.domainMap.put(dom.getDomainId().getDID(), dom);
    }

    public synchronized void remove(Domain dom) {
        this.domainMap.remove(dom.getDomainId().getDID());
    }

    public synchronized Domain get(DomainIdentifier did) {
        return (Domain)this.domainMap.get(did.getDID());
    }

    public synchronized Set getDomains(String domClassName) throws ClassNotFoundException {
        if (domClassName == null || domClassName == "" || this.domainMap.isEmpty()) {
            return null;
        }
        Object dom = null;
        HashSet<Object> domSet = new HashSet<Object>();
        Iterator domIter = this.domainMap.values().iterator();
        while (domIter.hasNext()) {
            dom = domIter.next();
            if (!Class.forName(domClassName).isAssignableFrom(dom.getClass())) continue;
            domSet.add(dom);
        }
        if (domSet.isEmpty()) {
            return null;
        }
        return domSet;
    }

    public static final class Init
    implements Runnable {
        private static DomainManager manager = null;

        public void run() {
            manager = DomainManager.getDomainManager();
        }
    }
}

